
//#pragma pack(4)

#define _AMD64_


//
// command definitions
#define WH32_COMMAND_FEDERAL_ONLY 0
#define WH32_COMMAND_FEDERAL_AND_STATE 1


struct MDATE{
  long month;
  long day;
  long year;
};



//
// master error return values
#define WH32_RETURN_FEDERAL_ERROR 1
#define WH32_RETURN_FICA_ERROR 2
#define WH32_RETURN_MEDICARE_ERROR 4
#define WH32_RETURN_STATE_ERROR 8
#define WH32_RETURN_COUNTY_ERROR 16
#define WH32_RETURN_LOCAL_ERROR 16
#define WH32_RETURN_CITY_ERROR 32
#define WH32_RETURN_SUPPLEMENTAL_ERROR 64;


//
// state definitions
#define WH32_ALABAMA 1
#define WH32_ALASKA  2
#define WH32_AMERICANSAMOA 3
#define WH32_ARIZONA 4
#define WH32_ARKANSAS 5
#define WH32_CALIFORNIA 6
#define WH32_COLORADO 7
#define WH32_CONNECTICUT  8
#define WH32_DELAWARE  9
#define WH32_DISTRICTOFCOLUMBIA 10
#define WH32_FEDERATEDSTATESOFMICRONESIA  11
#define WH32_FLORIDA 12
#define WH32_GEORGIA 13
#define WH32_GUAM 14
#define WH32_HAWAII 15
#define WH32_IDAHO 16
#define WH32_ILLINOIS  17
#define WH32_INDIANA 18
#define WH32_IOWA 19
#define WH32_KANSAS 20
#define WH32_KENTUCKY 21
#define WH32_LOUISIANA 22
#define WH32_MAINE 23
#define WH32_MARSHALLISLANDS 24
#define WH32_MARYLAND 25
#define WH32_MASSACHUSETTS 26
#define WH32_MICHIGAN 27
#define WH32_MINNESOTA 28
#define WH32_MISSISSIPPI 29
#define WH32_MISSOURI 30
#define WH32_MONTANA 31
#define WH32_NEBRASKA 32
#define WH32_NEVADA 33
#define WH32_NEWHAMPSHIRE 34
#define WH32_NEWJERSEY 35
#define WH32_NEWMEXICO 36
#define WH32_NEWYORK 37
#define WH32_NORTHCAROLINA 38
#define WH32_NORTHDAKOTA 39
#define WH32_NORTHERNMARIANAISLANDS 40
#define WH32_OHIO 41
#define WH32_OKLAHOMA 42
#define WH32_OREGON 43
#define WH32_PALAU 44
#define WH32_PENNSYLVANIA 45
#define WH32_PUERTORICO 46
#define WH32_RHODEISLAND 47
#define WH32_SOUTHCAROLINA 48
#define WH32_SOUTHDAKOTA 49
#define WH32_TENNESSEE 50
#define WH32_TEXAS 51
#define WH32_UTAH 52
#define WH32_VERMONT 53
#define WH32_VIRGINISLANDS 54
#define WH32_VIRGINIA 55
#define WH32_WASHINGTON 56
#define WH32_WESTVIRGINIA 57
#define WH32_WISCONSIN 58
#define WH32_WYOMING 59



//
// federal_error definitions
#define WH32_FEDERAL_NOTABLE 1
#define WH32_FEDERAL_STRUCT_ERROR 2
#define WH32_FEDERAL_ILLEGAL_PERIOD 3

//
// federal status
#define FEDERAL_STATUS_SINGLE 0
#define FEDERAL_STATUS_MARRIED 1
#define FEDERAL_STATUS_HEADOFHOUSEHOLD 2

//
// federal supplemental options
#define FEDERAL_SUPPLEMENTAL_FLAT_CALCULATION 0
#define FEDERAL_SUPPLEMENTAL_ADD_TO_SALARY 1


//
// fica eligibility
#define FEDERAL_FICA_ELIGIBLE 0
#define FEDERAL_FICA_EXEMPT 1

//
// medicare eligibility
#define FEDERAL_MEDICARE_ELIGIBLE 0
#define FEDERAL_MEDICARE_EXEMPT 1


//
// 
struct WITHHOLDING_IL_STRUC{
	long struct_size;
	long exemptions;
};


#pragma pack(4)
//
struct FEDERAL_WITHHOLDING_STRUC{
  long	struct_size;
  long  dummy;

  long	federal_error;
  long	federal_exemptions;
  MDATE	federal_table_date;
  long  federal_table;
  long  federal_period;
  double federal_taxable_pay;
  double federal_additional_withholding;
  
  MDATE table_used;
  double federal_withhold_amount;

  // federal social security info
  long	fica_error;
  long	fica_exempt;
  double federal_ficamedicare_pay;
  double	previous_fica_wages_this_year;
  double fica_withhold_amount;

  // federal medicare info
  long  medicare_error;
  long	medicare_exempt;
  double	previous_medicare_wages_this_year;
  double medicare_withhold_amount;

  // supplemental income info
  double supplemental_amount;
  double ytd_supplemental_amount;
  long supplemental_calc_type;
  long supplemental_tax_type;
  double supplemental_tax;

};



//
// state_error definitions
#define WH32_STATE_NOTABLE 1
#define WH32_ARIZONA_ILLEGALPERCENT 2
#define WH32_STATE_NOSTATE 3
#define WH32_STATE_STRUCT_ERROR 4


//
// state status
#define STATE_STATUS_SINGLE 0
#define STATE_STATUS_MARRIED 1
#define STATE_STATUS_HEADOFHOUSEHOLD 2
#define STATE_STATUS_MARRIEDSEPERATE 3

#define STATE_STATUS_MARRIED_ONE_WORKING 4		// GEORGIA 
#define STATE_STATUS_MARRIED_BOTH_WORKING 5		// GEORGIA & maine
#define STATE_STATUS_QUALIFYINGWIDOWER 6		// NEW JERSEY
#define STATE_STATUS_SURVIVINGSPOUSE 7		// nebraska
#define STATE_STATUS_NONE 8				// alabama
#define STATE_STATUS_MARRIED_SELF_ONLY 9	// ARKANSAS

//
// state supplemental options
#define STATE_SUPPLEMENTAL_FLAT_CALCULATION 0
#define STATE_SUPPLEMENTAL_ADD_TO_SALARY 1

//
// type of supplemental tax to apply
#define STATE_SUPPLEMENTAL_CA_BONUS_STOCK 0
#define STATE_SUPPLEMENTAL_CA_OTHER 1

// West Virginia special_field_1 options
// LOW_RATE means one working or one job
#define LOW_RATE 0
#define REGULAR RATE 1

//
// county error definitions
#define WH32_COUNTY_NOTABLE 1

//
// local error definitions
#define	WH32_LOCAL_NOTABLE 1


#pragma pack(4)

struct STATE_WITHHOLDING_STRUC{
  long  struct_size;
  long	state_error;
  long	state_number;
  long  state_allowances;	
  long  state_table;
  long  state_period;
  double  state_taxable_pay;
  double state_additional_withholding;
  MDATE	table_used;

  double state_withhold_amount;

  double arizona_withhold_percentage;
  long california_estimated_deductions;		// de-4 line 2
  long michigan_special_exemptions;			// mi-w4 line 13
  long michigan_claim_as_dependent;			// mi-w4 line 14
  long connecticut_filing_status;			// ct-w4 line 1
  double connecticut_reductional_amount;	// ct-w4 line 3
  long georgia_dependents;					// g-4 line 5b (5a is state_exemptions)
  long louisiana_dependents;				// l-4 line 7
  long massachusetts_headofhousehold;		// box a
  long massachusetts_blind;					// box b
  long massachusetts_spouse_blind;			// box c
  long massachusetts_student;				// box d
  long newjersey_table;						// w4 line 3
  long alabama_dependents;					// a4 line 3
  double mississippi_exemption_amount;		// line 6
  long special_field_1;                     // previously arkansas_low_income_qualified;		// ar4ec line 5
  long illinois_additional_allowances;					// ilw4 line 2
  long indiana_dependents;

  double supplemental_amount;
  double ytd_supplemental_amount;
  long supplemental_calc_type;
  long supplemental_tax_type;				// used for California
  double supplemental_tax;

};

struct COUNTY_WITHHOLDING_STRUC{
	long struct_size;
	long county_error;
	long county_number;
	long county_allowances;
	long county_table;
	long county_period;
	double county_taxable_pay;
	double county_additional_withholding;
	MDATE table_used;
	double county_withhold_amount;
	long indiana_resident;
	double percent_amount;
	double maximum;
	double year_to_date_withholding;
	long number_of_exemptions;
	double exemption_amount;
	double allowance_amount;
	double annual_opt;
	long	residence_number;
	double residence_withhold_amount;
	long   muni_type;

    double supplemental_amount;
	double ytd_supplemental_amount;
    long supplemental_calc_type;
    long supplemental_tax_type;				// used for California
    double supplemental_tax;

};

struct LOCAL_WITHHOLDING_STRUC{
	long struct_size;
	long error;
	long id_number;
	long allowances;
	long table;
	long period;
	double taxable_pay;
	double additional_withholding;
	MDATE table_used;
	double withhold_amount;
	long resident;
	double percent_amount;
	double maximum;
	double year_to_date_withholding;
	long number_of_exemptions;
	double exemption_amount;
	double fixed_allowance_amount;
	double annual_opt;
	long	residence_number;
	double residence_withhold_amount;
	long   muni_type;

    double supplemental_amount;
	double ytd_supplemental_amount;
    long supplemental_calc_type;
    long supplemental_tax_type;				// used for California
    double supplemental_tax;

};


struct WITHHOLDING_TAXBODY_INFO{
  long struct_size;
  long error;
  long state;
  long muni_type;
  long prompt_number;
  long desired_entry;      /*set by calling program, return info on this name*/
  long number_of_entries;  /*returned by function*/
  long muni_number;        /*returned by function if non-zero, used by state and present to customer*/
  long calc_number;        /*returned by function;  application uses this number in calls to
						                            calculation function*/
};


struct FEDERAL_TABLE{
  MDATE start_period;
  MDATE end_period;
  long table;
  long period;
  double exemption_amount;
  double bracketlow;
  double brackethigh;
  double amount;
  double pluspercent;
};


struct GENERAL_STATE_TABLE{
  MDATE start_period;
  MDATE end_period;
  long table;
  long period;
  double exemption_amount;
  double bracketlow;
  double brackethigh;
  double amount;
  double pluspercent;

};



#define WH32_GET_TABLE_INFO_NO_ERROR 0
#define WH32_GET_TABLE_INFO_INVALID_COMMAND 1
#define WH32_GET_TABLE_INFO_INVALID_DATE 2

#define WH32_TABLE_INFO_COMMAND_GET_FICA_MAX 1

struct WH32_TABLE_INFO{
  long struct_size;      // set by calling app 
  MDATE date;            // set by calling app
  long command;			 // set by calling app
  double value;			 // value returned by app
};







//
// definitions for local withholding 'id_number' follow
//



/*MISSOURI LOCAL TAXING DISTRICTS*/
#define WH32_MO_NONE 0
#define WH32_MO_STLOUIS 1
#define WH32_MO_KANSASCITY 2


#define OH_SCHOOL_DISTRICT_TAX 0
#define OH_MUNICIPAL_TAX 1

// OHIO SCHOOL DISTRICTS
// AS OF 2006.4 Ohio school districts will not be updated.
//              Use WH32_Get_Taxbody_Info
#define OH_3301_ADA_EVSD 1
#define OH_7501_ANNA_LSD 2
#define OH_1901_ANSONIA_LSD 3
#define OH_6301_ANTWERP_LSD 4
#define OH_1902_ARCANUM_BUTLER_LSD 5
#define OH_3202_ARLINGTON_LSD 6
#define OH_0701_BARNESVILLE_EVSD 7
#define OH_2801_BERKSHIRE_LSD	8
#define OH_7401_BETTSVILLE_LSD 9
#define OH_2101_BIG_WALNUT_LSD 10
#define OH_2303_BLOOM_CARROLL_LSD 11
#define OH_8701_BOWLING_GREEN_CSD 12
#define OH_5502_BRADFORD_EVSD 13
#define OH_1701_BUCKEYE_CENTRAL_LSD 14
#define OH_2102_BUCKEY_VALLEY_LSD 15
#define OH_2502_CANAL_WINCHESTER_LSD 16
#define OH_2902_CEDAR_CLIFF_LSD 17
#define OH_5401_CELINA_CSD 18
#define OH_4201_CENTERBURG_LSD 19
#define OH_2002_CENTRAL_LSD 20
#define OH_1303_CLERMONT_NORTHEASTERN_LSD 21
#define OH_5402_COLDWATER_EVSD 22
#define OH_6901_COLUMBUS_GROVE_LSD 23
#define OH_6902_CONTINENTAL_LSD 24
#define OH_3203_CORY_RAWSON_LSD 25
#define OH_5503_COVINGTON_EVSD 26
#define OH_1503_CRESTVIEW_LSD 27
#define OH_4202_DANVILLE_LSD 28
#define OH_2003_DEFIANCE_CSD 29
#define OH_6803_EATON_CSD 30
#define OH_8602_EDGERTON_LSD 31
#define OH_8703_ELMWOOD_LSD 32
#define OH_2602_EVERGREEN_LSD 33
#define OH_8001_FAIRBANKS_LSD 34
#define OH_2903_FAIRBORN_CSD 35
#define OH_2304_FAIRFIELD_UNION_LSD 36
#define OH_7503_FAIRLAWN_LSD 37
#define OH_7504_FORT_LORAMIE_LSD 38
#define OH_5406_FORT_RECORVERY_LSD 39
#define OH_1903_FRANKLIN_MONROE_LSD 40
#define OH_7202_FREMONT_CSD 41
#define OH_2603_GORHAM_FAYETTE_LSD 42
#define OH_1305_GOSHEN_LSD 43
#define OH_2904_GREENEVIEW_LSD 44
#define OH_1904_GREENVILLE_CSD 45
#define OH_7505_HARDIN_HOUSTON_LSD 46
#define OH_3302_HARDIN_NORTHERN_LSD 47
#define OH_2004_HICKSVILLE_EVSD 48
#define OH_5902_HIGHLAND_LSD 49
#define OH_3604_HILLSBORO_CSD 50
#define OH_3501_HOLGATE_LSD 51
#define OH_4901_JEFFERSON_LSD 52
#define OH_3303_KENTON_CSD 53
#define OH_6905_LEIPSIC_LSD 54
#define OH_3205_LIBERTY_BENTON_LSD 55
#define OH_3502_LIBERTY_CENTER_LSD 56
#define OH_2306_LIBERTY_UNION_THURSTON_LSD 57
#define OH_4506_LICKING_VALLEY_LSD 58
#define OH_0303_LOUDONVILLE_PERRYSVILLE_EVSD 59
#define OH_0905_MADISON_LSD 60
#define OH_7609_MASSILLON_CSD 61
#define OH_3206_MCCOMB_LSD 62
#define OH_1102_MECHANICSBURG_EVSD 63
#define OH_5504_MIAMI_EAST_LSD 64
#define OH_6906_MILLER_CITY_NEW_CLEVELAND_LSD 65
#define OH_1905_MISSISSINAWA_VALLEY_LSD 66
#define OH_8802_MOHAWK_LSD 67
#define OH_8605_MONPELIER_EVSD 68
#define OH_5903_MOUNT_GILEAD_EVSD 69
#define OH_6802_NATIONAL_TRAIL_LSD 70
#define OH_5708_NEW_LEBANON_LSD 71
#define OH_3903_NEW_LONDON_LSD 72
#define OH_0907_NEW_MIAMI_LSD 73
#define OH_7404_NEW_RIEGEL_LSD 74
#define OH_4507_NEWARK_CSD 75
#define OH_5506_NEWTON_LSD 76
#define OH_8003_NORTH_UNION_LSD 77
#define OH_5904_NORTHMOR_LSD 78
#define OH_4509_NORTHRIDGE_LSD 79
#define OH_8505_NORTHWESTERN_LSD 80
#define OH_3904_NORWALK_CSD 81
#define OH_4712_OBERLIN_CSD 82
#define OH_6907_OTTOWA_GLANDORF_LSD 83
#define OH_6909_PANDORA_GILBOA_LSD 84
#define OH_5405_PARKWAY_LSD 85
#define OH_3504_PATRICK_HENRY_LSD 86
#define OH_6302_PAULDING_EVSD 87
#define OH_8708_PERRYSBURG_EVSD 88
#define OH_2307_PICKERINGTON_LSD 89
#define OH_5507_PIQUA_CSD 90
#define OH_7007_PLYMOUGH_SHILOH_LSD 91
#define OH_6804_PREBLE_SHAWNEE_LSD 92
#define OH_2509_REYNOLDSBURG_CSD 93
#define OH_3304_RIDGEMONT_LSD 94
#define OH_3305_RIVERDALE_LSD 95
#define OH_4604_RIVERSIDE_LSD 96
#define OH_7507_RUSSIA_LSD 97
#define OH_1508_SALEM_CSD 98
#define OH_7105_SCIOTO_VALLEY_LSD 99
#define OH_7406_SENECA_EAST_LSD 100
#define OH_3905_SOUTH_CENTRAL_LSD 101
#define OH_1205_SOUTHEASTERN_LSD 102
#define OH_4510_SOUTHWEST_LICKING_LSD 103
#define OH_0209_SPENCERVILLE_LSD 104
#define OH_5010_SPRINGFIELD_LSD 105
#define OH_8607_STRYKER_LSD 106
#define OH_6503_TEAYS_VALLEY_LSD 107
#define OH_1103_TRIAD_LSD 108
#define OH_1906_TRI_VILLAGE_LSD 109
#define OH_7106_UNION_SCIOTO_LSD 110
#define OH_1510_UNITED_LSD 111
#define OH_8803_UPPER_SANDUSKY_EVSD 112
#define OH_3306_UPPER_SCIOTO_VALLEY_LSD 113
#define OH_5713_VALLEY_VIEW_LSD 114
#define OH_3208_VANLUE_LSD 115
#define OH_0605_WAPAKONETA_CSD 116
#define OH_6303_WAYNE_TRACE_LSD 117
#define OH_0606_WAYNESFIELD_GOSHEN_LSD 118
#define OH_4715_WELLINGTON_EVSD 119
#define OH_1105_WEST_LIBERTY_SALEM_LSD 120
#define OH_3906_WESTERN_RESERVE_LSD 121
#define OH_3122_WYOMING_CSD 122
#define OH_2906_XENIA_COMMUNITY_CSD 123
#define OH_7107_ZANE_TRACE_LSD 124
#define OH_YELLOW_SPRINGS 125
#define OH_BELLEVUE 126
#define OH_LEDGEMONT_LSD 127
#define OH_COLUMBIANA_EVSD 128
#define OH_OTSEGO_LSD 129
#define OH_PANDORA_GILBOA 130
#define OH_TWIN_VALLEY 131
#define OH_VINTON_COUNTY 132



// MARYLAND COUNTIES
#define MD_WORCESTER 24
#define MD_TALBOT 1
#define MD_HOWARD 2
#define MD_BALTIMORE_CITY 3
#define MD_ANNE_ARUNDEL 4
#define MD_CALVERT 5
#define MD_CECIL 6
#define MD_DORCHESTER 7
#define MD_FREDERICK 8
#define MD_GARRETT 9
#define MD_HARFORD 10
#define MD_KENT 11
#define MD_WASHINGTON 12
#define MD_BALTIMORE 13
#define MD_CAROLINE 14
#define MD_CARROLL 15
#define MD_QUEEN_ANNES 16
#define MD_ALLEGANY 17
#define MD_CHARLES 18
#define MD_MONTGOMERY 19
#define MD_ST_MARYS 20
#define MD_PRINCE_GEORGES 21
#define MD_SOMERSET 22
#define MD_WICOMICO 23


//INDIANA COUNTIES
#define INDIANA_COUNTY_RESIDENT 1

#define IN_ADAMS 1
#define IN_ALLEN 2
#define IN_BARTHOLOMEW 3 
#define IN_BENTON 4
#define IN_BLACKFORD 5
#define IN_BOONE 6
#define IN_BROWN 7
#define IN_CARROLL 8
#define IN_CASS 9
#define IN_CLAY 11
#define IN_CLINTON 12
#define IN_CRAWFORD 13
#define IN_DAVIESS 14
#define IN_DEARBORN 15
#define IN_DECATUR 16
#define IN_DEKALB 17
#define IN_DELAWARE 18
#define IN_DUBOIS 19
#define IN_ELKHART 20
#define IN_FAYETTE 21
#define IN_FLOYD 22
#define IN_FOUNTAIN 23
#define IN_FRANKLIN 24
#define IN_FULTON 25
#define IN_GIBSON 26
#define IN_GRANT 27
#define IN_GREENE 28
#define IN_HAMILTON 29
#define IN_HANCOCK 30
#define IN_HARRISON 31
#define IN_HENDRICKS 32
#define IN_HENRY 33
#define IN_HOWARD 34
#define IN_HUNTINGTON 35
#define IN_JACKSON 36
#define IN_JASPER 37
#define IN_JAY 38
#define IN_JENNINGS 39
#define IN_JOHNSON 41
#define IN_KNOX 42
#define IN_KOSCIUSKO 43
#define IN_LAGRANGE 44
#define IN_LAPORTE 46
#define IN_LAWRENCE 47
#define IN_MADISON 48
#define IN_MARION 49
#define IN_MARSHALL 50
#define IN_MARTIN 51
#define IN_MIAMI 52
#define IN_MONROE 53
#define IN_MONTGOMERY 54
#define IN_MORGAN 55
#define IN_NEWTON 56
#define IN_NOBLE 57
#define IN_OHIO 58
#define IN_ORANGE 59
#define IN_OWEN 60
#define IN_PARKE 61
#define IN_PERRY 62
#define IN_PIKE 63
#define IN_PULASKI 66
#define IN_PUTNAM 67
#define IN_RANDOLPH 68
#define IN_RIPLEY 69
#define IN_RUSH 70
#define IN_STJOSEPH 71
#define IN_SCOTT 72
#define IN_SHELBY 73
#define IN_SPENCER 74
#define IN_STARKE 75
#define IN_STEUBEN 76
#define IN_SWITZERLAND 78
#define IN_TIPPECANOE 79
#define IN_TIPTON 80
#define IN_UNION 81
#define IN_VANDERBURGH 82
#define IN_VERMILLION 83
#define IN_WABASH 85
#define IN_WARREN 86
#define IN_WARRICK 87
#define IN_WASHINGTON 88
#define IN_WAYNE 89
#define IN_WELLS 90
#define IN_WHITE 91
#define IN_WHITLEY 92
#define IN_CLARK 93
#define IN_PORTER 94
#define IN_VIGO 95
#define IN_JEFFERSON 96
#define IN_SULLIVAN 97

//NEW YORK LOCAL TAXING DISTRICTS
#define NY_YONKERS 1
#define NY_NEWYORKCITY 2
#define NY_OTHER 3

//COLORADO LOCAL TAXING DISTRICTS
#define CO_NONE 0
#define CO_DENVER 1
#define CO_AURORA 2
#define CO_GREENWOODVILLAGE 3
#define CO_SHERIDAN 4
#define CO_GLENDALE 5

//PENNSYLVANIA LOCAL TAXING DISTRICTS
#define PA_LOCAL_OPT_PAYPERIOD  0
#define PA_LOCAL_OPT_ANNUAL 1
#define PA_LOCAL_OPT_NONE 2

// PA muni_type field
#define PA_LOCAL_SCHOOL 0
#define PA_LOCAL_MUNICIPAL 1

#define LOCAL_RESIDENT 1
#define LOCAL_NONRESIDENT 0

// MICHIGAN LOCAL TAXING DISTRICTS
#define MI_OTHER	0
#define	MI_ALBION	1
#define	MI_BATTLE_CREEK 2
#define	MI_BIG_RAPIDS 3
#define MI_DETROIT 4
#define	MI_FLINT 5
#define MI_GRAND_RAPIDS 6
#define	MI_GRAYLING 7
#define	MI_HAMTRAMCK 8
#define MI_HIGHLAND_PARK 9
#define	MI_HUDSON 10
#define	MI_IONIA 11
#define	MI_JACKSON 12
#define	MI_LANSING 13
#define	MI_LAPEER 14
#define MI_MUSKEGON 15
#define	MI_MUSKEGON_HEIGHTS 16
#define	MI_PONTIAC 17
#define	MI_PORT_HURON 18
#define	MI_PORTLAND 19
#define MI_SAGINAW 20
#define	MI_SPRINGFIELD 21
#define	MI_WALKER 22



