// mfc_app_wh32Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "mfc_app_wh32.h"
#include "mfc_app_wh32Dlg.h"
#include "wh32.h"


extern "C" __declspec(dllimport) double WH32_Table_Version(void);
extern "C" __declspec(dllimport) long WH32_Calc_Local(long command,struct FEDERAL_WITHHOLDING_STRUC *WH,struct STATE_WITHHOLDING_STRUC *stwh,struct LOCAL_WITHHOLDING_STRUC *lcwh);
extern "C" __declspec(dllimport) long WH32_Get_Prompt(struct WITHHOLDING_TAXBODY_INFO *wt,char * buffer);

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// Cmfc_app_wh32Dlg dialog




Cmfc_app_wh32Dlg::Cmfc_app_wh32Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(Cmfc_app_wh32Dlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void Cmfc_app_wh32Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_fedwithhold, m_IDC_fedwithhold);
	DDX_Control(pDX, IDC_gross, m_IDC_gross);
	DDX_Control(pDX, IDC_fedstatus, m_IDC_fedstatus);
	DDX_Control(pDX, IDC_local_tax, m_IDC_local_tax);
	DDX_Control(pDX, IDC_statewithhold, m_IDC_statewithhold);
	DDX_Control(pDX, IDC_localwithhold, m_localwithhold);
}

BEGIN_MESSAGE_MAP(Cmfc_app_wh32Dlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &Cmfc_app_wh32Dlg::OnBnClickedButton1)
	ON_CBN_SELCHANGE(IDC_fedstatus, &Cmfc_app_wh32Dlg::OnCbnSelchangefedstatus)
END_MESSAGE_MAP()


// Cmfc_app_wh32Dlg message handlers

BOOL Cmfc_app_wh32Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	/*
	  set up combo box with local taxing districts
    */
	WITHHOLDING_TAXBODY_INFO wt;
	long ll,i;
	long max_entries;
	char thename[]="                                                                 "; 
	HINSTANCE hGetProcIDDLL = LoadLibrary(TEXT("wh32.dll"));
    FARPROC lpfnGetProcessID3 = GetProcAddress(HMODULE (hGetProcIDDLL),"WH32_Get_Prompt"); 
	typedef long(__stdcall * pICFUNC3)(WITHHOLDING_TAXBODY_INFO *wt,char * c);
	pICFUNC3 WH32_Get_Prompt;
	WH32_Get_Prompt=pICFUNC3(lpfnGetProcessID3);

	/*
	  First have function return total number of possible local
	  taxing names in parameter number_of_entries;
    */
	wt.desired_entry=0;
	wt.muni_number=0;
	wt.state=WH32_COLORADO;
    ll=WH32_Get_Prompt(&wt,&thename[0]);
	max_entries=wt.number_of_entries;

    /*
      Set up our prompt for Colorado places with local taxes
	*/
	for(i=0;i<max_entries;i++){
      wt.desired_entry=i;
      ll=WH32_Get_Prompt(&wt,&thename[0]);
      m_IDC_local_tax.AddString(&thename[0]);
	  m_local_tax_ids[i]=wt.calc_number;
	}
    m_IDC_local_tax.SetCurSel(0);


	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	/*
	  set up single/married combo
    */
	m_IDC_fedstatus.AddString("Married");
    m_IDC_fedstatus.AddString("Single");
	m_IDC_fedstatus.SetCurSel(1);


	return TRUE;  // return TRUE  unless you set the focus to a control
}

void Cmfc_app_wh32Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void Cmfc_app_wh32Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR Cmfc_app_wh32Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void Cmfc_app_wh32Dlg::OnBnClickedButton1()
{
	// TODO: Add your control notification handler code here

	FEDERAL_WITHHOLDING_STRUC fedwh;
    STATE_WITHHOLDING_STRUC stwh;
    LOCAL_WITHHOLDING_STRUC lowh;

	/*
	  Setup interface to wh32 dll
    */
	HINSTANCE hGetProcIDDLL = LoadLibrary(TEXT("wh32.dll"));
    FARPROC lpfnGetProcessID1 = GetProcAddress(HMODULE (hGetProcIDDLL),"WH32_Table_Version"); 
    FARPROC lpfnGetProcessID2 = GetProcAddress(HMODULE (hGetProcIDDLL),"WH32_Calc_Local"); 
	typedef double(__stdcall * pICFUNC)();
	typedef long(__stdcall * pICFUNC2)(long command,struct FEDERAL_WITHHOLDING_STRUC *WH,struct STATE_WITHHOLDING_STRUC *stwh,struct LOCAL_WITHHOLDING_STRUC *lcwh);
	pICFUNC WH32_Table_Version;
	pICFUNC2 WH32_Calc_Local;
	WH32_Table_Version=pICFUNC(lpfnGetProcessID1);
	WH32_Calc_Local=pICFUNC2(lpfnGetProcessID2);

	double dd;
	dd=WH32_Table_Version();
    CString s;
//    float x = atof(s);
    s.Format("%f",dd);
    m_IDC_fedwithhold.SetWindowText(s);  



	/*
	  Initialize structures used by calc function
    */
	fedwh.struct_size=sizeof(FEDERAL_WITHHOLDING_STRUC);
	fedwh.federal_error=0;  /*returned by function*/
	fedwh.federal_exemptions=0;
	fedwh.federal_table_date.year=2009;
	fedwh.federal_table_date.month=7;
	fedwh.federal_table_date.day=1;
	fedwh.federal_table=0;   /*default to single*/
    fedwh.federal_period=12;
	fedwh.federal_taxable_pay=0;
	fedwh.federal_additional_withholding=0;
	fedwh.fica_error=0;     /*returned by function*/
	fedwh.fica_exempt=0;    /*no for default*/
	fedwh.federal_ficamedicare_pay=fedwh.federal_taxable_pay;
	fedwh.previous_fica_wages_this_year=0;
	fedwh.medicare_exempt=0;
	fedwh.previous_medicare_wages_this_year=0;
	fedwh.supplemental_amount=0;
	fedwh.ytd_supplemental_amount=0;
	fedwh.supplemental_calc_type=0;
	fedwh.supplemental_tax_type=0;

	stwh.struct_size=sizeof(STATE_WITHHOLDING_STRUC);
	stwh.special_field_1=0;
	stwh.state_additional_withholding=0;
	stwh.state_allowances=0;
	stwh.state_error=0;   /*returned by function*/
	stwh.state_number=WH32_COLORADO;  /*we're only going to do Colorado here*/
	stwh.state_period=fedwh.federal_period;
	stwh.state_table=0;
	stwh.state_taxable_pay=0;
	stwh.supplemental_amount=0;
	stwh.supplemental_calc_type=0;
	stwh.supplemental_tax_type=0;
	stwh.ytd_supplemental_amount=0;

	lowh.struct_size=sizeof(LOCAL_WITHHOLDING_STRUC);
	lowh.additional_withholding=0;
	lowh.allowances=0;
	lowh.annual_opt=0;
	lowh.error=0;         /*returned by function*/
    lowh.exemption_amount=0;
	lowh.fixed_allowance_amount=0;
	lowh.id_number=0;
	lowh.maximum=0;
	lowh.muni_type=0;
	lowh.number_of_exemptions=0;
	lowh.period=12;
	lowh.residence_number=0;
	lowh.supplemental_amount=0;
	lowh.supplemental_calc_type=0;
	lowh.supplemental_tax_type=0;
	lowh.table=0;
	lowh.taxable_pay=0;
	lowh.year_to_date_withholding=0;
	lowh.ytd_supplemental_amount=0;


	


	/*
	  Retrieve user inputs from form
    */
    m_IDC_gross.GetWindowText(s);
	fedwh.federal_taxable_pay=atof(s);
	stwh.state_taxable_pay=fedwh.federal_taxable_pay;
	lowh.taxable_pay=fedwh.federal_taxable_pay;

	m_IDC_fedstatus.GetLBText(m_IDC_fedstatus.GetCurSel(),s);
	if(s=="Single"){
		fedwh.federal_table=FEDERAL_STATUS_SINGLE;
		stwh.state_table=STATE_STATUS_SINGLE;
		lowh.table=STATE_STATUS_SINGLE;
	}
	else{
		fedwh.federal_table=FEDERAL_STATUS_MARRIED;
		stwh.state_table=STATE_STATUS_MARRIED;
		lowh.table=STATE_STATUS_MARRIED;
	}


	lowh.id_number=m_local_tax_ids[m_IDC_local_tax.GetCurSel()];
	lowh.struct_size=sizeof(LOCAL_WITHHOLDING_STRUC);
	lowh.muni_type=0;
	

    /*
	  now calculate the taxes
    */

    WH32_Calc_Local(WH32_COMMAND_FEDERAL_AND_STATE,
		            &fedwh,
					&stwh,
					&lowh);


	/*
	  format output
    */

    s.Format("%10.2f",fedwh.federal_withhold_amount);
    m_IDC_fedwithhold.SetWindowText(s);  

	s.Format("%10.2f",stwh.state_withhold_amount);
    m_IDC_statewithhold.SetWindowText(s);  

	s.Format("%10.2f",lowh.withhold_amount);
    m_localwithhold.SetWindowText(s);  

}

void Cmfc_app_wh32Dlg::OnCbnSelchangefedstatus()
{
	// TODO: Add your control notification handler code here
}
